# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

#### Public Classes

* [`candlepin`](#candlepin)
* [`candlepin::repo`](#candlepin--repo): Manage the yum repository

#### Private Classes

* `candlepin::artemis`: Configuration for Artemis
* `candlepin::config`: Configuration for Candlepin
* `candlepin::database::mysql`: Candlepin Database Setup using Mysql
* `candlepin::database::postgresql`: Candlepin Database Setup using Postgresql
* `candlepin::database::postgresql::encoding`: Class to ensure the packages for encoding are installed
* `candlepin::install`: Candlepin installation packages
* `candlepin::params`: Candlepin params
* `candlepin::service`: Candlepin Service and Initialization

### Resource types

* [`cpdb_update`](#cpdb_update): Runs cpdb update command to migrate the database

### Data types

* [`Candlepin::LogLevel`](#Candlepin--LogLevel): A log4j log level

## Classes

### <a name="candlepin"></a>`candlepin`

The candlepin class.

#### Examples

##### Set debug logging

```puppet
class { 'candlepin':
  loggers => {
    'org.candlepin' => 'DEBUG',
  },
}
```

#### Parameters

The following parameters are available in the `candlepin` class:

* [`facts_match_regex`](#-candlepin--facts_match_regex)
* [`db_ssl`](#-candlepin--db_ssl)
* [`db_ssl_verify`](#-candlepin--db_ssl_verify)
* [`db_ssl_ca`](#-candlepin--db_ssl_ca)
* [`db_name`](#-candlepin--db_name)
* [`db_user`](#-candlepin--db_user)
* [`db_password`](#-candlepin--db_password)
* [`user_groups`](#-candlepin--user_groups)
* [`log_dir`](#-candlepin--log_dir)
* [`loggers`](#-candlepin--loggers)
* [`env_filtering_enabled`](#-candlepin--env_filtering_enabled)
* [`keystore_file`](#-candlepin--keystore_file)
* [`keystore_password`](#-candlepin--keystore_password)
* [`keystore_type`](#-candlepin--keystore_type)
* [`truststore_file`](#-candlepin--truststore_file)
* [`truststore_password`](#-candlepin--truststore_password)
* [`ca_key`](#-candlepin--ca_key)
* [`ca_cert`](#-candlepin--ca_cert)
* [`ca_key_password`](#-candlepin--ca_key_password)
* [`ciphers`](#-candlepin--ciphers)
* [`tls_versions`](#-candlepin--tls_versions)
* [`version`](#-candlepin--version)
* [`java_package`](#-candlepin--java_package)
* [`adapter_module`](#-candlepin--adapter_module)
* [`enable_basic_auth`](#-candlepin--enable_basic_auth)
* [`enable_trusted_auth`](#-candlepin--enable_trusted_auth)
* [`consumer_system_name_pattern`](#-candlepin--consumer_system_name_pattern)
* [`enable_hbm2ddl_validate`](#-candlepin--enable_hbm2ddl_validate)
* [`ssl_port`](#-candlepin--ssl_port)
* [`host`](#-candlepin--host)
* [`candlepin_conf_file`](#-candlepin--candlepin_conf_file)
* [`tomcat_base`](#-candlepin--tomcat_base)
* [`tomcat_conf`](#-candlepin--tomcat_conf)
* [`java_home`](#-candlepin--java_home)
* [`catalina_home`](#-candlepin--catalina_home)
* [`catalina_tmpdir`](#-candlepin--catalina_tmpdir)
* [`java_opts`](#-candlepin--java_opts)
* [`lang`](#-candlepin--lang)
* [`security_manager`](#-candlepin--security_manager)
* [`shutdown_wait`](#-candlepin--shutdown_wait)
* [`expired_pools_schedule`](#-candlepin--expired_pools_schedule)
* [`artemis_port`](#-candlepin--artemis_port)
* [`artemis_host`](#-candlepin--artemis_host)
* [`artemis_client_dn`](#-candlepin--artemis_client_dn)
* [`broker_config_file`](#-candlepin--broker_config_file)
* [`user`](#-candlepin--user)
* [`group`](#-candlepin--group)
* [`disable_fips`](#-candlepin--disable_fips)
* [`db_manage_on_startup`](#-candlepin--db_manage_on_startup)
* [`manage_db`](#-candlepin--manage_db)
* [`init_db`](#-candlepin--init_db)
* [`db_type`](#-candlepin--db_type)
* [`db_host`](#-candlepin--db_host)
* [`db_port`](#-candlepin--db_port)
* [`oauth_key`](#-candlepin--oauth_key)
* [`oauth_secret`](#-candlepin--oauth_secret)

##### <a name="-candlepin--facts_match_regex"></a>`facts_match_regex`

Data type: `Optional[String[1]]`

Optional regex to filter consumer facts; if provided, will be added to the
Candlepin configuration file.

Default value: `undef`

##### <a name="-candlepin--db_ssl"></a>`db_ssl`

Data type: `Boolean`

Boolean indicating if the connection to the database should be over an SSL
connection.

Default value: `false`

##### <a name="-candlepin--db_ssl_verify"></a>`db_ssl_verify`

Data type: `Boolean`

Boolean indicating if the SSL connection to the database should be verified

Default value: `true`

##### <a name="-candlepin--db_ssl_ca"></a>`db_ssl_ca`

Data type: `Optional[Stdlib::Absolutepath]`

The CA certificate to verify the SSL connection to the database with

Default value: `undef`

##### <a name="-candlepin--db_name"></a>`db_name`

Data type: `String`

The name of the Candlepin database

Default value: `'candlepin'`

##### <a name="-candlepin--db_user"></a>`db_user`

Data type: `String`

The Candlepin database username

Default value: `'candlepin'`

##### <a name="-candlepin--db_password"></a>`db_password`

Data type: `Variant[Sensitive[String], String]`

The Candlepin database password

Default value: `$candlepin::params::db_password`

##### <a name="-candlepin--user_groups"></a>`user_groups`

Data type: `Variant[Array[String], String]`

The user groups for the Candlepin tomcat user

Default value: `[]`

##### <a name="-candlepin--log_dir"></a>`log_dir`

Data type: `Stdlib::Absolutepath`

Directory for Candlepin logs

Default value: `'/var/log/candlepin'`

##### <a name="-candlepin--loggers"></a>`loggers`

Data type: `Hash[String[1], Candlepin::LogLevel]`

Set the log levels for loggers

Default value: `{}`

##### <a name="-candlepin--env_filtering_enabled"></a>`env_filtering_enabled`

Data type: `Boolean`

If subscription filtering is done on a per environment basis

Default value: `true`

##### <a name="-candlepin--keystore_file"></a>`keystore_file`

Data type: `Stdlib::Absolutepath`

Tomcat keystore file to use

Default value: `'/etc/candlepin/certs/keystore'`

##### <a name="-candlepin--keystore_password"></a>`keystore_password`

Data type: `Optional[Variant[Sensitive[String], String]]`

Password for keystore being used with Tomcat

Default value: `undef`

##### <a name="-candlepin--keystore_type"></a>`keystore_type`

Data type: `String`

Keystore type

Default value: `'PKCS12'`

##### <a name="-candlepin--truststore_file"></a>`truststore_file`

Data type: `Stdlib::Absolutepath`

Truststore file to use for Tomcat and Artemis

Default value: `'/etc/candlepin/certs/truststore'`

##### <a name="-candlepin--truststore_password"></a>`truststore_password`

Data type: `Optional[Variant[Sensitive[String], String]]`

Password for truststore being used with Tomcat and Artemis

Default value: `undef`

##### <a name="-candlepin--ca_key"></a>`ca_key`

Data type: `Stdlib::Absolutepath`

CA key file to use

Default value: `'/etc/candlepin/certs/candlepin-ca.key'`

##### <a name="-candlepin--ca_cert"></a>`ca_cert`

Data type: `Stdlib::Absolutepath`

CA certificate file to use

Default value: `'/etc/candlepin/certs/candlepin-ca.crt'`

##### <a name="-candlepin--ca_key_password"></a>`ca_key_password`

Data type: `Optional[Variant[Sensitive[String], String]]`

CA key password

Default value: `undef`

##### <a name="-candlepin--ciphers"></a>`ciphers`

Data type: `Array[String]`

Allowed ciphers for ssl connection

Default value: `$candlepin::params::ciphers`

##### <a name="-candlepin--tls_versions"></a>`tls_versions`

Data type: `Array[String]`

Allowed versions of TLS, for example 1.1, 1.2, etc

Default value: `['1.2']`

##### <a name="-candlepin--version"></a>`version`

Data type: `String`

Version of Candlepin to install

Default value: `'present'`

##### <a name="-candlepin--java_package"></a>`java_package`

Data type: `Optional[String[1]]`

Use in conjunction with java_home to specify the JVM used by Tomcat

Default value: `undef`

##### <a name="-candlepin--adapter_module"></a>`adapter_module`

Data type: `Optional[String]`

Candlepin adapter implementations to inject into the java runtime

Default value: `undef`

##### <a name="-candlepin--enable_basic_auth"></a>`enable_basic_auth`

Data type: `Boolean`

Whether to enable HTTP basic auth

Default value: `true`

##### <a name="-candlepin--enable_trusted_auth"></a>`enable_trusted_auth`

Data type: `Boolean`

Whether to enable trusted auth

Default value: `false`

##### <a name="-candlepin--consumer_system_name_pattern"></a>`consumer_system_name_pattern`

Data type: `Optional[String]`

Regex that consistutes a valid consumer name

Default value: `undef`

##### <a name="-candlepin--enable_hbm2ddl_validate"></a>`enable_hbm2ddl_validate`

Data type: `Boolean`

If true will perform a schema check to ensure compliance with the models.
Disabling this feature may be required if modifications are required to schema

Default value: `true`

##### <a name="-candlepin--ssl_port"></a>`ssl_port`

Data type: `Stdlib::Port`

Port to deploy SSL enabled Tomcat server on

Default value: `8443`

##### <a name="-candlepin--host"></a>`host`

Data type: `Stdlib::Host`

Host to deploy Tomcat server on; defaults to localhost

Default value: `'localhost'`

##### <a name="-candlepin--candlepin_conf_file"></a>`candlepin_conf_file`

Data type: `Stdlib::Absolutepath`

Configuration file location for candlepin

Default value: `'/etc/candlepin/candlepin.conf'`

##### <a name="-candlepin--tomcat_base"></a>`tomcat_base`

Data type: `Stdlib::Absolutepath`

In new-style instances, if CATALINA_BASE isn't specified, it will be
constructed by joining TOMCATS_BASE and NAME.

Default value: `'/var/lib/tomcats/'`

##### <a name="-candlepin--tomcat_conf"></a>`tomcat_conf`

Data type: `Stdlib::Absolutepath`

Where your the tomcat configuration lives

Default value: `'/etc/tomcat'`

##### <a name="-candlepin--java_home"></a>`java_home`

Data type: `Stdlib::Absolutepath`

Where your java installation lives

Default value: `'/usr/lib/jvm/jre'`

##### <a name="-candlepin--catalina_home"></a>`catalina_home`

Data type: `Stdlib::Absolutepath`

Where your tomcat installation lives

Default value: `'/usr/share/tomcat'`

##### <a name="-candlepin--catalina_tmpdir"></a>`catalina_tmpdir`

Data type: `Stdlib::Absolutepath`

System-wide tmp

Default value: `'/var/cache/tomcat/temp'`

##### <a name="-candlepin--java_opts"></a>`java_opts`

Data type: `String`

Java Parameters

Default value: `'-Xms1024m -Xmx4096m'`

##### <a name="-candlepin--lang"></a>`lang`

Data type: `Optional[String]`

Tomcat locale setting

Default value: `undef`

##### <a name="-candlepin--security_manager"></a>`security_manager`

Data type: `Boolean`

Run tomcat under the Java Security Manager

Default value: `false`

##### <a name="-candlepin--shutdown_wait"></a>`shutdown_wait`

Data type: `Optional[Integer[0]]`

Time to wait in seconds, before killing process

Default value: `undef`

##### <a name="-candlepin--expired_pools_schedule"></a>`expired_pools_schedule`

Data type: `String`

Quartz schedule notation for how often to run the ExpiredPoolsJob

Default value: `'0 0 0 * * ?'`

##### <a name="-candlepin--artemis_port"></a>`artemis_port`

Data type: `Stdlib::Port`

Port to expose Artemis on

Default value: `61613`

##### <a name="-candlepin--artemis_host"></a>`artemis_host`

Data type: `Stdlib::Host`

Host address to have Artemis listen on; defaults to localhost

Default value: `'localhost'`

##### <a name="-candlepin--artemis_client_dn"></a>`artemis_client_dn`

Data type: `Variant[Deferred, String]`

Full DN for the client certificate used to talk to Artemis

Default value: `'CN=ActiveMQ Artemis Client, OU=Artemis, O=ActiveMQ, L=AMQ, ST=AMQ, C=AMQ'`

##### <a name="-candlepin--broker_config_file"></a>`broker_config_file`

Data type: `Stdlib::Absolutepath`

Config file for Artemis

Default value: `'/etc/candlepin/broker.xml'`

##### <a name="-candlepin--user"></a>`user`

Data type: `String`

User under which Candlepin will run

Default value: `'tomcat'`

##### <a name="-candlepin--group"></a>`group`

Data type: `String`

Primary group for the Candlepin user

Default value: `'tomcat'`

##### <a name="-candlepin--disable_fips"></a>`disable_fips`

Data type: `Boolean`

Disable FIPS within the Java environment for Tomcat explicitly.
When set to false, no flag is added. Then on FIPS enabled systems, a Candlepin build that supports FIPS is required.

Default value: `true`

##### <a name="-candlepin--db_manage_on_startup"></a>`db_manage_on_startup`

Data type: `Enum['None', 'Report', 'Halt', 'Manage']`

How to manage database migrations on startup.

Default value: `'Manage'`

##### <a name="-candlepin--manage_db"></a>`manage_db`

Data type: `Boolean`



Default value: `true`

##### <a name="-candlepin--init_db"></a>`init_db`

Data type: `Boolean`



Default value: `true`

##### <a name="-candlepin--db_type"></a>`db_type`

Data type: `Enum['postgresql','mysql']`



Default value: `'postgresql'`

##### <a name="-candlepin--db_host"></a>`db_host`

Data type: `Stdlib::Host`



Default value: `'localhost'`

##### <a name="-candlepin--db_port"></a>`db_port`

Data type: `Optional[Stdlib::Port]`



Default value: `undef`

##### <a name="-candlepin--oauth_key"></a>`oauth_key`

Data type: `Variant[Sensitive[String], String]`



Default value: `'candlepin'`

##### <a name="-candlepin--oauth_secret"></a>`oauth_secret`

Data type: `Variant[Sensitive[String], String]`



Default value: `'candlepin'`

### <a name="candlepin--repo"></a>`candlepin::repo`

Manage the yum repository

#### Parameters

The following parameters are available in the `candlepin::repo` class:

* [`version`](#-candlepin--repo--version)
* [`dist`](#-candlepin--repo--dist)
* [`gpgcheck`](#-candlepin--repo--gpgcheck)
* [`gpgkey`](#-candlepin--repo--gpgkey)
* [`baseurl`](#-candlepin--repo--baseurl)

##### <a name="-candlepin--repo--version"></a>`version`

Data type: `Variant[Undef, Enum['nightly'], Pattern['^\d+\.\d+$']]`

Which yum repository to install. For example latest or 3.3. Note that the
versions are Katello releases.

Default value: `undef`

##### <a name="-candlepin--repo--dist"></a>`dist`

Data type: `String`

The dist code to use in the URL

Default value: `"el${facts['os']['release']['major']}"`

##### <a name="-candlepin--repo--gpgcheck"></a>`gpgcheck`

Data type: `Boolean`

Whether to check the GPG signatures

Default value: `false`

##### <a name="-candlepin--repo--gpgkey"></a>`gpgkey`

Data type: `Optional[String]`

The GPG key to use

Default value: `undef`

##### <a name="-candlepin--repo--baseurl"></a>`baseurl`

Data type: `Optional[Stdlib::HTTPUrl]`

An optional base URL to be used for yumrepo, instead of the default

Default value: `undef`

## Resource types

### <a name="cpdb_update"></a>`cpdb_update`

Runs cpdb update command to migrate the database

#### Properties

The following properties are available in the `cpdb_update` type.

##### `ensure`

Valid values: `present`, `absent`

The basic property that the resource should be in.

Default value: `present`

#### Parameters

The following parameters are available in the `cpdb_update` type.

* [`db_host`](#-cpdb_update--db_host)
* [`db_name`](#-cpdb_update--db_name)
* [`db_password`](#-cpdb_update--db_password)
* [`db_port`](#-cpdb_update--db_port)
* [`db_user`](#-cpdb_update--db_user)
* [`provider`](#-cpdb_update--provider)
* [`ssl_options`](#-cpdb_update--ssl_options)

##### <a name="-cpdb_update--db_host"></a>`db_host`

Database host

##### <a name="-cpdb_update--db_name"></a>`db_name`


##### <a name="-cpdb_update--db_password"></a>`db_password`

Password of the database user

##### <a name="-cpdb_update--db_port"></a>`db_port`

Database port

##### <a name="-cpdb_update--db_user"></a>`db_user`

User to connect to the database with

##### <a name="-cpdb_update--provider"></a>`provider`

The specific backend to use for this `cpdb_update` resource. You will seldom need to specify this --- Puppet will
usually discover the appropriate provider for your platform.

##### <a name="-cpdb_update--ssl_options"></a>`ssl_options`

SSL options if necessary for connecting to the database

## Data types

### <a name="Candlepin--LogLevel"></a>`Candlepin::LogLevel`

A log4j log level

Alias of `Enum['ALL', 'DEBUG', 'INFO', 'WARN', 'ERROR', 'FATAL', 'OFF', 'TRACE']`

