# @summary Possible keys for the [Unit] section of a unit file
# @see https://www.freedesktop.org/software/systemd/man/systemd.unit.html
#
type Systemd::Unit::Unit = Struct[
  {
    Optional['Description']               => Variant[String,Array[String,1]],
    Optional['Documentation']             => Variant[String,Array[String,1]],
    Optional['Wants']                     => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['Requires']                  => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['Requisite']                 => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['BindsTo']                   => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['PartOf']                    => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['Upholds']                   => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['Conflicts']                 => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['Before']                    => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['After']                     => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['OnFailure']                 => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['OnSuccess']                 => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['PropagatesReloadTo']        => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['ReloadPropagatedFrom']      => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['PropagatesStopTo']          => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['StopPropagatedFrom']        => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['JoinsNamespaceOf']          => Variant[Enum[''],Systemd::Unit,Array[Variant[Enum[''],Systemd::Unit],1]],
    Optional['RequiresMountsFor']         => Variant[Enum[''],Stdlib::Unixpath,Array[Variant[Enum[''],Stdlib::Unixpath],1]],
    Optional['OnSuccessJobMode']          => Enum['fail', 'replace', 'replace-irreversibly', 'isolate', 'flush', 'ignore-dependencies', 'ignore-requirements'],
    Optional['OnFailureJobMode']          => Enum['fail', 'replace', 'replace-irreversibly', 'isolate', 'flush', 'ignore-dependencies', 'ignore-requirements'],
    Optional['IgnoreOnIsolate']           => Boolean,
    Optional['StopWhenUnneeded']          => Boolean,
    Optional['RefuseManualStart']         => Boolean,
    Optional['RefuseManualStop']          => Boolean,
    Optional['AllowIsolate']              => Boolean,
    Optional['DefaultDependencies']       => Boolean,
    Optional['SurviveFinalKillSignal']    => Boolean,
    Optional['CollectMode']               => Enum['inactive', 'inactive-or-failed'],
    Optional['FailureAction']             => Enum['none', 'reboot', 'reboot-force', 'reboot-immediate', 'poweroff', 'poweroff-force', 'poweroff-immediate', 'exit', 'exit-force', 'soft-reboot', 'soft-reboot-force', 'kexec', 'kexec-force', 'halt', 'halt-force', 'halt-immediate'],
    Optional['SuccessAction']             => Enum['none', 'reboot', 'reboot-force', 'reboot-immediate', 'poweroff', 'poweroff-force', 'poweroff-immediate', 'exit', 'exit-force', 'soft-reboot', 'soft-reboot-force', 'kexec', 'kexec-force', 'halt', 'halt-force', 'halt-immediate'],
    Optional['FailureActionExitStatus']   => Variant[Enum[''],Integer[0, 255]],
    Optional['SuccessActionExitStatus']   => Variant[Enum[''],Integer[0, 255]],
    # Conditions and Asserts
    Optional['AssertPathExists']          => Variant[Enum[''],Stdlib::Unixpath,Pattern[/^!.*$/],Array[Variant[Enum[''],Stdlib::Unixpath,Pattern[/^!.*$/]],1]],
    Optional['AssertPathIsDirectory']     => Variant[Enum[''],Stdlib::Unixpath,Pattern[/^!.*$/],Array[Variant[Enum[''],Stdlib::Unixpath,Pattern[/^!.*$/]],1]],
    Optional['ConditionPathExists']       => Variant[Enum[''],Stdlib::Unixpath,Pattern[/^!.*$/],Array[Variant[Enum[''],Stdlib::Unixpath,Pattern[/^!.*$/]],1]],
    Optional['ConditionPathIsDirectory']  => Variant[Enum[''],Stdlib::Unixpath,Pattern[/^!.*$/],Array[Variant[Enum[''],Stdlib::Unixpath,Pattern[/^!.*$/]],1]],
    Optional['ConditionPathIsMountPoint'] => Variant[Enum[''],Stdlib::Unixpath,Pattern[/^!.*$/],Array[Variant[Enum[''],Stdlib::Unixpath,Pattern[/^!.*$/]],1]],
    Optional['StartLimitIntervalSec']     => String[1],
    Optional['StartLimitBurst']           => Integer[1],
  }
]
