Foreman::SettingManager.define(:foreman) do
  locales = -> { Hash['' => _("Browser locale")].merge(Hash[Foreman::Gettext::Support.human_available_locales.map { |lang| [lang[1], lang[0]] }]) }
  timezones = -> { Hash['' => _("Browser timezone")].merge(Hash[ActiveSupport::TimeZone.all.map { |tz| [tz.name, "(GMT #{tz.formatted_offset}) #{tz.name}"] }]) }

  category(:general, N_('General')) do
    setting('administrator',
      type: :string,
      description: N_("The default administrator email address"),
      default: "root@#{SETTINGS[:domain]}",
      full_name: N_('Administrator email address'),
      validate: :email)
    setting('foreman_url',
      type: :string,
      description: N_("URL where your Foreman instance is reachable (see also Provisioning > unattended_url)"),
      default: "#{SETTINGS[:require_ssl] ? 'https' : 'http'}://#{SETTINGS[:fqdn]}",
      full_name: N_('Foreman URL'),
      validate: :http_url)
    setting('entries_per_page',
      type: :integer,
      description: N_("Number of records shown per page in Foreman"),
      default: 20,
      full_name: N_('Entries per page'))
    setting('db_pending_seed',
      type: :boolean,
      description: N_("Should the `foreman-rake db:seed` be executed on the next run of the installer modules?"),
      default: true,
      full_name: N_('DB pending seed'))
    setting('proxy_request_timeout',
      type: :integer,
      description: N_("Open and read timeout for HTTP requests from Foreman to Smart Proxy (in seconds)"),
      default: 60,
      full_name: N_('Smart Proxy request timeout'))
    setting('login_text',
      type: :text,
      description: N_("Text to be shown in the login-page footer. Keyword $VERSION is replaced by current version."),
      default: N_("Version") + " $VERSION",
      full_name: N_('Login page footer text'))
    setting('http_proxy',
      type: :string,
      description: N_('Set an HTTP(s) proxy for all outgoing HTTP(S) connections from Foreman. System-wide proxies must be configured at the operating system level.'),
      default: nil,
      full_name: N_('HTTP(S) proxy'))
    validates(:http_proxy, { http_url: { allow_blank: true } })
    setting('http_proxy_except_list',
      type: :array,
      description: N_('Set hostnames to which requests are not to be proxied. Requests to the local host are excluded by default.'),
      default: [],
      full_name: N_('HTTP(S) proxy except hosts'))
    setting('lab_features',
      type: :boolean,
      description: N_("Whether or not to show a menu to access experimental lab features (requires reload of page)"),
      default: false,
      full_name: N_('Show Experimental Labs'))
    setting('new_hosts_page',
      type: :boolean,
      description: N_("Whether or not to show the new overview page for All Hosts"),
      default: true,
      full_name: N_('Show New Host Overview Page'))
    setting('display_fqdn_for_hosts',
      type: :boolean,
      description: N_('Display names of hosts as FQDNs. If disabled, only display names of hosts as hostnames.'),
      default: true,
      full_name: N_('Display FQDN for hosts'))
    setting('outofsync_interval',
      type: :integer,
      description: N_('Duration in minutes after servers are classed as out of sync. ' \
                      'This setting is overridden by specific settings from config management tools (e.g. puppet_interval, ansible_interval).'),
      default: 30,
      full_name: N_('Out of sync interval'))
    setting('instance_id',
      type: :string,
      description: N_("Foreman instance ID, uniquely identifies this Foreman instance."),
      default: nil,
      full_name: N_('Foreman UUID'))
    setting('default_locale',
      type: :string,
      description: N_("Language to use for new users"),
      default: nil,
      full_name: N_('Default language'),
      collection: locales)
    setting('default_timezone',
      type: :string,
      description: N_("Timezone to use for new users"),
      default: nil,
      full_name: N_('Default timezone'),
      collection: timezones)
    setting('instance_title',
      type: :string,
      description: N_("The instance title is shown above the header in a banner (requires a page reload)."),
      default: nil,
      full_name: N_('Instance title'))
    setting('instance_color',
      type: :string,
      description: N_("Hex value for color for the instance title banner. It will only be used if an instance title is defined. If no valid value is given, the default value is: #000000. (requires a page reload)"),
      default: '#000000',
      full_name: N_('Instance color'))
    setting('audits_period',
      type: :integer,
      description: N_('Duration in days to preserve audits for. Leave empty to disable the audits cleanup.'),
      default: nil,
      full_name: N_('Saved audits interval'))
    setting('host_details_ui',
      type: :boolean,
      description: N_("Foreman will load the new UI for host details"),
      default: true,
      full_name: N_('New host details UI'))
  end
end
