require File.join(Rails.root, 'db', 'seeds.d', '020-permissions_list.rb')

desc 'Export Foreman permissions to JavaScript'
task export_permissions: :environment do
  formatted = PermissionsList.permissions.map { |permission| "export const #{permission[1].upcase} = '#{permission[1]}';\n" }
  File.open(File.join(Rails.root, 'webpack/assets/javascripts/react_app/permissions.js'), 'w') do |f|
    f.puts '/* eslint-disable */'
    f.puts '/* This file is automatically generated. Run "bundle exec rake export_permissions" to regenerate it. */'
    formatted.each { |line| f.puts line }
  end
end
