import React from 'react';
import { Provider } from 'react-redux';
import { mount } from 'enzyme';

import store from '../../../redux';
import ToastsList, { addToast, deleteToast } from '../index'
import { toast } from './fixtures'

describe('ToastsList', () => {
  it('integration', () => {
    const component = mount(
      <Provider store={store}>
        <ToastsList />
      </Provider>);

    let alerts = component.find('.pf-v5-c-alert.foreman-toast');
    expect(alerts.length).toBe(0);

    store.dispatch(addToast(toast));
    component.update();
    alerts = component.find('.pf-v5-c-alert.foreman-toast');
    expect(alerts.length).toBe(1);
    expect(component.find('.pf-v5-c-alert__title').at(0).text()).toBe('Success alert:message');

    store.dispatch(deleteToast(toast.key));
    component.update();
    alerts = component.find('.pf-v5-c-alert.foreman-toast');
    expect(alerts.length).toBe(0);
  });
});
