const fs = require('fs');
const path = require('path');

function generateExports(directoryPath, exportFileContent = '') {
  fs.readdirSync(directoryPath, { withFileTypes: true }).forEach(dirent => {
    if (
      dirent.isDirectory() &&
      dirent.name !== '__mocks__' &&
      dirent.name !== '__tests__'
    ) {
      const subDirectoryPath = path.join(directoryPath, dirent.name);
      exportFileContent = generateExports(subDirectoryPath, exportFileContent);
    } else if (dirent.isFile()) {
      const fileNameWithoutExtension = path.parse(dirent.name).name;
      const fileExtension = path.parse(dirent.name).ext;

      if (
        fileExtension === '.js' &&
        !dirent.name.endsWith('.test.js') &&
        !dirent.name.endsWith('.fixtures.js') &&
        !dirent.name.endsWith('mockRequests.js') &&
        !dirent.name.endsWith('vendor-core.scss') &&
        !dirent.name.endsWith('jquery.js') &&
        !fileNameWithoutExtension.includes('TestHelper') &&
        !fileNameWithoutExtension.includes('testHelper') &&
        !fileNameWithoutExtension.includes('APITestSetup') &&
        !fileNameWithoutExtension.includes('vendor-core.scss')
      ) {
        let relativeFilePath = path.relative(
          __dirname,
          path.join(directoryPath, fileNameWithoutExtension)
        );
        relativeFilePath = relativeFilePath.substring(
          relativeFilePath.indexOf('react_app') + 'react_app'.length + 1
        );
        let fileName = relativeFilePath.replace(/\\/g, '/').replace(/\//g, '_'); // replace slashes with underscores
        fileName = fileName.replace(/\./g, ''); // remove dots

        if (fileName.endsWith('_index')) {
          fileName = fileName.substring(0, fileName.length - '_index'.length); // remove _index
        }

        exportFileContent += `import * as ${fileName} from './react_app/${relativeFilePath.replace(
          /\\/g,
          '/'
        )}';\n`;
        exportFileContent += `export { ${fileName} };\n`;
      }
    }
  });

  return exportFileContent;
}

const generateExportsFile = () => {
  let exportFileContent = generateExports(path.join(__dirname, 'react_app'));
  exportFileContent = `/* eslint-disable */\n// This file is autogenerated by the webpack/assets/javascripts/exportAll.js script\n// Please do not modify this file directly\n\n${exportFileContent}`;

  fs.writeFileSync(
    path.join(__dirname, 'all_react_app_exports.js'),
    exportFileContent
  );
};

module.exports = { generateExportsFile };
